//=============================================================================
// DiseaseDamAmplify.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.1 2024/12/16 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 異常特効機構プラグイン
 * @target MZ
 * @author くろあめ
 *
 * @help
 * 指定のメタタグをメモ欄に記載することで
 * その要素を持つアクター/エネミーが、特定のステートが付与されている対象に攻撃する場合
 * もしくは、自身に特定のステートが付与されているとき攻撃を行う場合に
 * 威力を増幅させる機能を搭載するプラグインです。
 * 
 * 
 * ======================================================================================= 
 * 
 * 
 * アクター、エネミー、スキル、職業、装備、ステートのメモ欄に
 * <DiseaseAmplify:xx|a,b,c>と記載することで、その要素を持つアクター/エネミーが
 * ID:a,b,c番のステートが付与されている対象に攻撃する際に、その威力をxx%増幅させます
 * 対象のステートはカンマ区切りで複数指定可能です、最後のIDの後にカンマはつけないでください。
 * 
 * 【設定例】
 * <DiseaseAmplify:200|4,5,6> とメモ欄に記載されたスキルで攻撃する場合 
 * 対象に、ID:2,3,4番のステート(デフォルトでは毒、暗闇、沈黙)が付与されている場合
 * そのダメージは200%上昇します。
 * 
 * <DiseaseAmplify:50|10> とメモ欄に記載されたエネミーのすべての攻撃は
 * 対象に、ID:10番のステート(デフォルトでは睡眠)が付与されている場合
 * 50%威力が上昇します。
 *
 * <DiseaseAmplify:30|13> とメモ欄に記載された武器を装備するアクターのすべての攻撃は
 * 対象に、ID:13番のステート(デフォルトではスタン)が付与されている場合
 * 30%威力が上昇します。
 * 
 * 増幅率には、マイナス指定が可能です。
 * 
 * <DiseaseAmplify> メタタグは
 * メモ帳ひとつにつき1つの記載しか有効になりません
 * 複数の装備やステートなどに記載された分は、全て加味されます。
 *
 * 
 * ======================================================================================= 
 * 
 * 
 * アクター、エネミー、スキル、職業、装備、ステートのメモ欄に
 * <ReinforceAmplify:xx|a,b,c>と記載することで、その要素を持つアクター/エネミーが
 * ID:a,b,c番のステートが付与されている対象に攻撃する際に、その威力をxx%増幅させます
 * 対象のステートはカンマ区切りで複数指定可能です、最後のIDの後にカンマはつけないでください。
 * 
 * 【設定例】
 * <ReinforceAmplify:200|4,5,6> とメモ欄に記載されたスキルで攻撃する場合 
 * 自身に、ID:2,3,4番のステート(デフォルトでは毒、暗闇、沈黙)が付与されている場合
 * そのダメージは200%上昇します。
 * 
 * <ReinforceAmplify:50|10> とメモ欄に記載されたエネミーのすべての攻撃は
 * 自身に、ID:10番のステート(デフォルトでは睡眠)が付与されている場合
 * 50%威力が上昇します。
 *
 * <ReinforceAmplify:30|13> とメモ欄に記載された武器を装備するアクターのすべての攻撃は
 * 自身に、ID:13番のステート(デフォルトではスタン)が付与されている場合
 * 30%威力が上昇します。
 * 
 * 増幅率には、マイナス指定が可能です。
 * 
 * <ReinforceAmplify> メタタグは
 * メモ帳ひとつにつき1つの記載しか有効になりません
 * 複数の装備やステートなどに記載された分は、全て加味されます。
 * 
 * 
 * ======================================================================================= 
 * 
 * 
 * スキルのメモ欄に
 * <TargetStateNumAmplify:xxx|yyy|a,b,c>と記載することで
 * そのスキルを受けるアクター/エネミーに、a,b,cのステートの数が付与されている数だけ
 * スキルの最終与ダメージを増幅させます（上限値を設定可能です）
 * 対象のステートはカンマ区切りで複数指定可能です、最後のIDの後にカンマはつけないでください。
 * 
 * 【設定例】
 * <TargetStateNumAmplify:50|300|4,5,6,7,8,9> とメモ欄に記載されたスキルで攻撃する場合 
 * スキルの対象に、ID:4,5,6,7,8,9番のステートが付与されている場合
 * そのダメージ指定のステートひとつにつき50%上昇します
 * ただし、300%(この場合はステート4つ以上)を超える場合は、上昇値は300%で上限となります。
 * 
 * 増幅率には、マイナス指定が可能です。
 * 
 * <TargetStateNumAmplify> メタタグは
 * スキルのメモ帳ひとつにつき1つの記載しか有効になりません。
 * 
 * 
 * ======================================================================================= 
 * 
 * 
 * スキルのメモ欄に
 * <SelfStateNumAmplify:xxx|yyy|a,b,c>と記載することで
 * そのスキルを使うアクター/エネミーに、a,b,cのステートの数が付与されている数だけ
 * スキルの最終与ダメージを増幅させます（上限値を設定可能です）
 * 対象のステートはカンマ区切りで複数指定可能です、最後のIDの後にカンマはつけないでください。
 * 
 * 【設定例】
 * <SelfStateNumAmplify:50|300|4,5,6,7,8,9> とメモ欄に記載されたスキルで攻撃する場合 
 * 自身に、ID:4,5,6,7,8,9番のステートが付与されている場合
 * そのダメージ指定のステートひとつにつき50%上昇します
 * ただし、300%(この場合はステート4つ以上)を超える場合は、上昇値は300%で上限となります。
 * 
 * 増幅率には、マイナス指定が可能です。
 * 
 * <SelfStateNumAmplify> メタタグは
 * スキルのメモ帳ひとつにつき1つの記載しか有効になりません。
 * 
 * 
 * ======================================================================================= 
 * 
 * 
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 * 
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */


(function() {

/* 異常特効率値取得 */
Game_BattlerBase.prototype.calcDiseaseAmplify = function(target,value,item) {
    
    var targetState = [];
    var states = target.states();
    var getMeta;
    var getState;
    
    for (let i = 0; i < states.length; i++) {
        targetState.push(states[i].id);
    }
    
    if (targetState.length == 0) return value;
    
    if (item && item.meta && item.meta.DiseaseAmplify) {
        getMeta  = item.meta.DiseaseAmplify.split('|');
        getState = getMeta[1].split(',').map(Number);
        value = this.checkDiseaseAmplify(value,Number(getMeta[0]),targetState,getState);
    }
    
    const thisStates = this.states();
    for (let i = 0; i < thisStates.length; i++) {
        if (thisStates[i] && thisStates[i].meta && thisStates[i].meta.DiseaseAmplify){
            getMeta  = thisStates[i].meta.DiseaseAmplify.split('|');
            getState = getMeta[1].split(',').map(Number);
            value = this.checkDiseaseAmplify(value,Number(getMeta[0]),targetState,getState);
        }
    }

    if(this.isActor()){
        if (this.actor() && this.actor().meta && this.actor().meta.DiseaseAmplify) {
            getMeta  = this.actor().meta.DiseaseAmplify.split('|');
            getState = getMeta[1].split(',').map(Number);
            value = this.checkDiseaseAmplify(value,Number(getMeta[0]),targetState,getState);
        }

        if (this.currentClass() && this.currentClass().meta && this.currentClass().meta.DiseaseAmplify)  {
            getMeta  = this.currentClass().meta.DiseaseAmplify.split('|');
            getState = getMeta[1].split(',').map(Number);
            value = this.checkDiseaseAmplify(value,Number(getMeta[0]),targetState,getState);
        }
        
        const equips = this.equips();
        for (let i = 0; i < equips.length; i++) {      
            if (equips[i] && equips[i].meta && equips[i].meta.DiseaseAmplify){
                getMeta  = equips[i].meta.DiseaseAmplify.split('|');
                getState = getMeta[1].split(',').map(Number);
                value = this.checkDiseaseAmplify(value,Number(getMeta[0]),targetState,getState);
            }
        }
    }
    else{
        if (this.enemy() && this.enemy().meta && this.enemy().meta.DiseaseAmplify) {
            getMeta  = this.enemy().meta.DiseaseAmplify.split('|');
            getState = getMeta[1].split(',').map(Number);
            value = this.checkDiseaseAmplify(value,Number(getMeta[0]),targetState,getState);
        }
    }
    
    return value;
};

Game_BattlerBase.prototype.checkDiseaseAmplify = function(value,amplify,targetState,checkState) {
    for (let i = 0; i < targetState.length; i++){
        if(checkState.indexOf(targetState[i]) !== -1){
            return value * amplify / 100;
        }
    }
    return value;
}

/* 特殊ステート時強化措置率値取得 */
Game_BattlerBase.prototype.calcReinforceAmplify = function(target,value,item) {
    
    var targetState = [];
    var states = this.states();
    var getMeta;
    var getState;
    
    for (let i = 0; i < states.length; i++) {
        targetState.push(states[i].id);
    }
    
    if (targetState.length == 0) return value;
    
    if (item && item.meta && item.meta.ReinforceAmplify) {
        getMeta  = item.meta.ReinforceAmplify.split('|');
        getState = getMeta[1].split(',').map(Number);
        value = this.checkReinforceAmplify(value,Number(getMeta[0]),targetState,getState);
    }
    
    const thisStates = this.states();
    for (let i = 0; i < thisStates.length; i++) {
        if (thisStates[i] && thisStates[i].meta && thisStates[i].meta.ReinforceAmplify){
            getMeta  = thisStates[i].meta.ReinforceAmplify.split('|');
            getState = getMeta[1].split(',').map(Number);
            value = this.checkReinforceAmplify(value,Number(getMeta[0]),targetState,getState);
        }
    }

    if(this.isActor()){
        if (this.actor() && this.actor().meta && this.actor().meta.ReinforceAmplify) {
            getMeta  = this.actor().meta.ReinforceAmplify.split('|');
            getState = getMeta[1].split(',').map(Number);
            value = this.checkReinforceAmplify(value,Number(getMeta[0]),targetState,getState);
        }

        if (this.currentClass() && this.currentClass().meta && this.currentClass().meta.ReinforceAmplify)  {
            getMeta  = this.currentClass().meta.ReinforceAmplify.split('|');
            getState = getMeta[1].split(',').map(Number);
            value = this.checkReinforceAmplify(value,Number(getMeta[0]),targetState,getState);
        }
        
        const equips = this.equips();
        for (let i = 0; i < equips.length; i++) {      
            if (equips[i] && equips[i].meta && equips[i].meta.ReinforceAmplify){
                getMeta  = equips[i].meta.ReinforceAmplify.split('|');
                getState = getMeta[1].split(',').map(Number);
                value = this.checkReinforceAmplify(value,Number(getMeta[0]),targetState,getState);
            }
        }
    }
    else{
        if (this.enemy() && this.enemy().meta && this.enemy().meta.ReinforceAmplify) {
            getMeta  = this.enemy().meta.ReinforceAmplify.split('|');
            getState = getMeta[1].split(',').map(Number);
            value = this.checkReinforceAmplify(value,Number(getMeta[0]),targetState,getState);
        }
    }
    
    return value;
};

Game_BattlerBase.prototype.checkReinforceAmplify = function(value,amplify,targetState,checkState) {
    for (let i = 0; i < targetState.length; i++){
        if(checkState.indexOf(targetState[i]) !== -1){
            return value * amplify / 100;
        }
    }
    return value;
}

/* ステート数強化倍率値取得 */
Game_BattlerBase.prototype.calcStateNumAmplify = function(target,value,item) {
    
    // 自身の付与ステート数で強化
    if (item && item.meta && item.meta.SelfStateNumAmplify) {
        var targetState = [];
        var getMeta    = item.meta.SelfStateNumAmplify.split('|');
        var plusRate   = Number(getMeta[0]);
        var rateLimit  = Number(getMeta[1]);
        var checkState = getMeta[2].split(',').map(Number);
        // 自身のステートが対象
        var states = this.states();
        var ampRate = 100; 
        
        for (let i = 0; i < states.length; i++) {
            targetState.push(states[i].id);
        }
        
        if (targetState.length > 0) {
            for (let i = 0; i < targetState.length; i++){
                if(checkState.indexOf(targetState[i]) !== -1){
                    ampRate += plusRate;
                }
            }
        }
        ampRate = ampRate < rateLimit ? ampRate : rateLimit;
        
        value = value * ampRate / 100;
    }

    // 敵の付与ステート数で強化
    if (item && item.meta && item.meta.TargetStateNumAmplify) {
        var targetState = [];
        var getMeta    = item.meta.TargetStateNumAmplify.split('|');
        var plusRate   = Number(getMeta[0]);
        var rateLimit  = Number(getMeta[1]);
        var checkState = getMeta[2].split(',').map(Number);
        // 敵のステートが対象
        var states = target.states();
        var ampRate = 100; 
        
        for (let i = 0; i < states.length; i++) {
            targetState.push(states[i].id);
        }
        
        if (targetState.length > 0) {
            for (let i = 0; i < targetState.length; i++){
                if(checkState.indexOf(targetState[i]) !== -1){
                    ampRate += plusRate;
                }
            }
        }
        ampRate = ampRate < rateLimit ? ampRate : rateLimit;
        
        value = value * ampRate / 100;
    }
    
    return value;

}

/* ダメージ計算関数の末尾で属性出力を加味 */
const _Game_Action_makeDamageValue_disDamAply = Game_Action.prototype.makeDamageValue;
Game_Action.prototype.makeDamageValue = function(target, critical){
    var value = _Game_Action_makeDamageValue_disDamAply.apply(this, arguments);
    
    //console.log(this.subject().name());
    //console.log(this.item().name);
    //console.log(value);
    
    value = this.subject().calcDiseaseAmplify(target,value,this.item());
    value = this.subject().calcReinforceAmplify(target,value,this.item());
    value = this.subject().calcStateNumAmplify(target,value,this.item());
    
    //console.log("After Amplify");
    //console.log(value);
    
    return Math.round(value);
};

})();